/*
 ============================================================================
 Name        : lab4week2.c
 Author      : 
 Version     :
 Copyright   : Your copyright notice
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#ifndef MODULE
#define MODULE
#endif

#ifndef __KERNEL__
#define __KERNEL__
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <rtai_sem.h>
#include <rtai_sched.h>
#include <linux/version.h>
#include <linux/errno.h>
#include <rtai_fifos.h>
#include <linux/random.h>


MODULE_LICENSE("GPL");

unsigned long *ptr,*pbdr, *pbddr;
static RT_TASK task1, task2, task3, task4;
static SEM semap;
RTIME period;
int x1, x2, x3, P1, P2, P3;
//RTIME ttt;

//structure for FIFO data
typedef struct str_purche
{
    int m_id, qty;
} purchaseStr;

static void Thread1(int data)
{
	purchaseStr order_detail;
	int swflag;

	//prepare order
	order_detail.m_id = data;
	order_detail.qty = 1;
	while(1)
		{
			//do stuff

		if((*pbdr | 0xE0) == 0xFE) swflag = 1;
		if((*pbdr | 0xE0) == 0xEF) swflag = 0;
		if(swflag == 1){
			int status = rtf_put(0, &order_detail, sizeof(order_detail));
		}
			//printk("Put %d with status %d\n",timedata, status);

		//rt_sleep(nano2count(1000000));

			rt_task_wait_period();

			//Random and set a new time period to the thread
			get_random_bytes(&x1, sizeof(x1)); //random number
			P1 = (x1 % 100)+1; //set it to 1-100
			//set new time period
			if(data == 1)
			rt_task_make_periodic(&task1, rt_get_time() + 10*period, P1*period);
			else if(data == 2)
				rt_task_make_periodic(&task2, rt_get_time() + 10*period, P1*period);
			else rt_task_make_periodic(&task3, rt_get_time() + 10*period, P1*period);
		}
}

int init_module(void)
{
	purchaseStr myData;

	//setup PORT B
	ptr = (unsigned long*)__ioremap(0x80840000,4096,0);
	pbdr = ptr + 1;
	pbddr = ptr + 5;
	*pbddr = 0xE0; //Setup input-output

	rtf_create(0,1*sizeof(myData));	//create fifo 0

	rt_set_periodic_mode();
	period = start_rt_timer(nano2count(1000000)); //set base time to 1ms

	//Create real time task
	rt_task_init(&task1, Thread1, 1,256, 0, 0, 0);
	rt_task_make_periodic(&task1, rt_get_time()+10*period, 1*period);
	rt_task_init(&task2, Thread1, 2,256, 0, 0, 0);
	rt_task_make_periodic(&task2, rt_get_time()+10*period, 1*period);
	rt_task_init(&task3, Thread1, 3,256, 0, 0, 0);
	rt_task_make_periodic(&task3, rt_get_time()+10*period, 1*period);


	rt_task_resume(&task1);
	rt_task_resume(&task2);
	rt_task_resume(&task3);

	return 0;
}

void cleanup_module(void)
{

	rt_task_delete(&task1);
	rt_task_delete(&task2);
	rt_task_delete(&task3);

	stop_rt_timer();
}
